/*
 * Decompiled with CFR 0.152.
 */
package com.ashiepleb.velocitynexus.backend.listener;

import com.ashiepleb.velocitynexus.backend.menu.MenuManager;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;

public class MenuListener
implements Listener {
    private final MenuManager menuManager;

    public MenuListener(MenuManager menuManager) {
        this.menuManager = menuManager;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null) {
            return;
        }
        Inventory openMenu = this.menuManager.getOpenMenu(player);
        if (openMenu == null || !clickedInventory.equals((Object)openMenu)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getSlot();
        this.sendClickToProxy(player, slot);
        player.closeInventory();
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.menuManager.hasMenuOpen(player)) {
            return;
        }
        this.sendCloseToProxy(player);
        this.menuManager.closeMenu(player);
    }

    private void sendClickToProxy(Player player, int slot) {
        try {
            ByteArrayOutputStream msgBytes = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(msgBytes);
            out.writeUTF("CLICK");
            out.writeInt(slot);
            player.sendPluginMessage(player.getServer().getPluginManager().getPlugin("VelocityNexus-Backend"), "velocitynexus:menu", msgBytes.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendCloseToProxy(Player player) {
        try {
            ByteArrayOutputStream msgBytes = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(msgBytes);
            out.writeUTF("CLOSE");
            player.sendPluginMessage(player.getServer().getPluginManager().getPlugin("VelocityNexus-Backend"), "velocitynexus:menu", msgBytes.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

