/*
 * Decompiled with CFR 0.152.
 */
package com.ashiepleb.velocityNexus.listener;

import com.ashiepleb.velocityNexus.menu.MenuManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.slf4j.Logger;

public class PluginMessageListener {
    private static final MinecraftChannelIdentifier MENU_CHANNEL = MinecraftChannelIdentifier.from((String)"velocitynexus:menu");
    private final MenuManager menuManager;
    private final Logger logger;

    public PluginMessageListener(MenuManager menuManager, Logger logger) {
        this.menuManager = menuManager;
        this.logger = logger;
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent event) {
        if (!event.getIdentifier().equals((Object)MENU_CHANNEL)) {
            return;
        }
        if (!(event.getSource() instanceof ServerConnection)) {
            return;
        }
        ServerConnection serverConnection = (ServerConnection)event.getSource();
        Player player = serverConnection.getPlayer();
        try {
            String action;
            ByteArrayInputStream msgBytes = new ByteArrayInputStream(event.getData());
            DataInputStream in = new DataInputStream(msgBytes);
            switch (action = in.readUTF()) {
                case "CLICK": {
                    int slot = in.readInt();
                    this.menuManager.handleClick(player, slot);
                    this.logger.debug("Player {} clicked slot {} in menu", (Object)player.getUsername(), (Object)slot);
                    break;
                }
                case "CLOSE": {
                    this.menuManager.closeMenu(player);
                    this.logger.debug("Player {} closed menu", (Object)player.getUsername());
                    break;
                }
                default: {
                    this.logger.warn("Unknown menu action: {}", (Object)action);
                    break;
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to read plugin message", (Throwable)e);
        }
        event.setResult(PluginMessageEvent.ForwardResult.handled());
    }
}

