/*
 * Decompiled with CFR 0.152.
 */
package com.ashiepleb.velocityNexus;

import com.ashiepleb.velocityNexus.commands.ServerCommand;
import com.ashiepleb.velocityNexus.commands.VelocityNexusCommand;
import com.ashiepleb.velocityNexus.config.ConfigManager;
import com.ashiepleb.velocityNexus.listener.PluginMessageListener;
import com.ashiepleb.velocityNexus.menu.MenuManager;
import com.ashiepleb.velocityNexus.menu.ServerSelectorMenu;
import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import org.slf4j.Logger;

@Plugin(id="velocitynexus", name="Velocity Nexus", version="1.0.0", description="Velocity Nexus transforms your Velocity proxy into an intuitive server hub by replacing the default /server command with a customizable GUI interface. Players can seamlessly navigate between servers with beautiful, user-friendly menus while administrators maintain full control over server access and presentation.", authors={"AshiePleb"})
public class VelocityNexus {
    private final ProxyServer proxy;
    private final Logger logger;
    private final Path dataDirectory;
    private ConfigManager configManager;
    private MenuManager menuManager;
    private ServerSelectorMenu textMenu;

    @Inject
    public VelocityNexus(ProxyServer proxy, Logger logger, @DataDirectory Path dataDirectory) {
        this.proxy = proxy;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.logger.info("Initializing Velocity Nexus...");
        this.configManager = new ConfigManager(this.dataDirectory, this.logger);
        this.configManager.loadConfig();
        this.menuManager = new MenuManager(this.proxy, this.configManager, this.logger);
        this.textMenu = new ServerSelectorMenu(this.proxy, this.configManager);
        this.registerListeners();
        this.registerCommands();
        this.logger.info("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513");
        this.logger.info("\u2503  Velocity Nexus v1.0.0 - Enabled!     \u2503");
        this.logger.info("\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u252b");
        this.logger.info("\u2503  Commands:                             \u2503");
        this.logger.info("\u2503    /server - Open GUI selector         \u2503");
        this.logger.info("\u2503    /velocitynexus - Plugin info        \u2503");
        this.logger.info("\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u252b");
        this.logger.info("\u2503  Note: Backend plugin required on      \u2503");
        this.logger.info("\u2503  Spigot/Paper servers for GUI!         \u2503");
        this.logger.info("\u2517\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b");
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        if (this.menuManager != null) {
            this.menuManager.shutdown();
        }
        this.logger.info("Velocity Nexus has been disabled");
    }

    private void registerListeners() {
        EventManager eventManager = this.proxy.getEventManager();
        eventManager.register((Object)this, (Object)new PluginMessageListener(this.menuManager, this.logger));
    }

    private void registerCommands() {
        CommandManager commandManager = this.proxy.getCommandManager();
        CommandMeta velocityNexusMeta = commandManager.metaBuilder("velocitynexus").plugin((Object)this).build();
        commandManager.register(velocityNexusMeta, (Command)new VelocityNexusCommand(this));
        if (this.configManager.isOverrideServerCommand()) {
            commandManager.unregister("server");
            CommandMeta serverMeta = commandManager.metaBuilder("server").plugin((Object)this).build();
            commandManager.register(serverMeta, (Command)new ServerCommand(this.menuManager, this.textMenu));
            this.logger.info("Overridden default /server command with GUI menu interface");
        }
        this.logger.info("Commands registered: /velocitynexus (info) and /server (GUI)");
    }

    public void reloadConfig() {
        this.configManager.loadConfig();
        this.logger.info("Configuration reloaded");
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public ServerSelectorMenu getTextMenu() {
        return this.textMenu;
    }
}

