/*
 * Decompiled with CFR 0.152.
 */
package com.ashiepleb.velocityNexus.commands;

import com.ashiepleb.velocityNexus.VelocityNexus;
import com.velocitypowered.api.command.SimpleCommand;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class VelocityNexusCommand
implements SimpleCommand {
    private final VelocityNexus plugin;
    private final MiniMessage miniMessage;

    public VelocityNexusCommand(VelocityNexus plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
    }

    public void execute(SimpleCommand.Invocation invocation) {
        String subCommand;
        String[] args = (String[])invocation.arguments();
        if (args.length == 0) {
            this.sendInfo(invocation);
            return;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                if (!invocation.source().hasPermission("velocitynexus.admin")) {
                    invocation.source().sendMessage(this.miniMessage.deserialize((Object)"<red>You don't have permission to use this command!"));
                    return;
                }
                this.plugin.reloadConfig();
                invocation.source().sendMessage(this.miniMessage.deserialize((Object)"<green>\u2713 Configuration reloaded successfully!"));
                break;
            }
            case "help": 
            case "info": {
                this.sendInfo(invocation);
                break;
            }
            case "version": 
            case "ver": {
                invocation.source().sendMessage(this.miniMessage.deserialize((Object)""));
                invocation.source().sendMessage(this.miniMessage.deserialize((Object)"<gradient:#00D9FF:#7B2FBE><bold>Velocity Nexus</bold></gradient> <gray>v1.0.0"));
                invocation.source().sendMessage(this.miniMessage.deserialize((Object)"<gray>Made by <white>AshiePleb"));
                invocation.source().sendMessage(this.miniMessage.deserialize((Object)""));
                break;
            }
            default: {
                invocation.source().sendMessage(this.miniMessage.deserialize((Object)"<red>Unknown subcommand. Use <yellow>/velocitynexus help</yellow> for help."));
            }
        }
    }

    private void sendInfo(SimpleCommand.Invocation invocation) {
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)""));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)"<gradient:#00D9FF:#7B2FBE><bold>Velocity Nexus</bold></gradient> <gray>v1.0.0"));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)"<gray>Transform your Velocity proxy with inventory GUI server selection!"));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)"<gray><strikethrough>\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501</strikethrough>"));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)""));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)"<gold><bold>Commands:</bold>"));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)"  <yellow>/server</yellow> <dark_gray>\u2192</dark_gray> <gray>Open inventory GUI server selector"));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)"  <yellow>/server <name></yellow> <dark_gray>\u2192</dark_gray> <gray>Connect to a specific server"));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)"  <yellow>/velocitynexus</yellow> <dark_gray>\u2192</dark_gray> <gray>Show plugin information"));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)"  <yellow>/velocitynexus reload</yellow> <dark_gray>\u2192</dark_gray> <gray>Reload configuration <dark_gray>(admin)</dark_gray>"));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)"  <yellow>/velocitynexus version</yellow> <dark_gray>\u2192</dark_gray> <gray>Show plugin version"));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)""));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)"<gold><bold>Features:</bold>"));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)"  <green>\u2713</green> <gray>Inventory GUI with clickable items"));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)"  <green>\u2713</green> <gray>Real-time player counts"));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)"  <green>\u2713</green> <gray>Beautiful gradient formatting"));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)"  <green>\u2713</green> <gray>Per-server permissions"));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)""));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)"<gray><strikethrough>\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501</strikethrough>"));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)"<gray>Made with <red>\u2764</red> by <white>AshiePleb"));
        invocation.source().sendMessage(this.miniMessage.deserialize((Object)""));
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return true;
    }
}

