/*
 * Decompiled with CFR 0.152.
 */
package com.ashiepleb.velocityNexus.config;

import com.moandjiezana.toml.Toml;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class ConfigManager {
    private final Path dataDirectory;
    private final Logger logger;
    private Toml config;

    public ConfigManager(Path dataDirectory, Logger logger) {
        this.dataDirectory = dataDirectory;
        this.logger = logger;
    }

    public void loadConfig() {
        try {
            Path configPath = this.dataDirectory.resolve("config.toml");
            if (!Files.exists(this.dataDirectory, new LinkOption[0])) {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
            }
            if (!Files.exists(configPath, new LinkOption[0])) {
                try (InputStream in = this.getClass().getResourceAsStream("/config.toml");){
                    if (in != null) {
                        Files.copy(in, configPath, new CopyOption[0]);
                        this.logger.info("Created default configuration file");
                    }
                }
            }
            this.config = new Toml().read(configPath.toFile());
            this.logger.info("Configuration loaded successfully");
        }
        catch (IOException e) {
            this.logger.error("Failed to load configuration", (Throwable)e);
        }
    }

    public String getMenuTitle() {
        return this.config.getString("menu.title", "<gradient:#00D9FF:#7B2FBE>Server Selector</gradient>");
    }

    public int getMenuRows() {
        return this.config.getLong("menu.rows", Long.valueOf(3L)).intValue();
    }

    public Map<String, ServerConfig> getServers() {
        HashMap<String, ServerConfig> servers = new HashMap<String, ServerConfig>();
        Toml serversTable = this.config.getTable("servers");
        if (serversTable != null) {
            for (Map.Entry entry : serversTable.entrySet()) {
                String serverName = (String)entry.getKey();
                if (!(entry.getValue() instanceof Toml)) continue;
                Toml serverData = (Toml)entry.getValue();
                ServerConfig serverConfig = new ServerConfig(serverName, serverData.getString("display-name", serverName), serverData.getList("description", List.of()), serverData.getString("icon", "SERVER"), serverData.getLong("slot", Long.valueOf(0L)).intValue(), serverData.getBoolean("enabled", Boolean.valueOf(true)), serverData.getString("permission", null));
                servers.put(serverName, serverConfig);
            }
        }
        return servers;
    }

    public boolean isUpdatePlayerCount() {
        return this.config.getBoolean("settings.update-player-count", Boolean.valueOf(true));
    }

    public boolean isSoundsEnabled() {
        return this.config.getBoolean("settings.sounds-enabled", Boolean.valueOf(true));
    }

    public boolean isOverrideServerCommand() {
        return this.config.getBoolean("settings.override-server-command", Boolean.valueOf(true));
    }

    public String getOfflineServerMessage() {
        return this.config.getString("settings.offline-server-message", "<red>This server is currently offline!");
    }

    public String getNoPermissionMessage() {
        return this.config.getString("settings.no-permission-message", "<red>You don't have permission to access this server!");
    }

    public static class ServerConfig {
        private final String internalName;
        private final String displayName;
        private final List<String> description;
        private final String icon;
        private final int slot;
        private final boolean enabled;
        private final String permission;

        public ServerConfig(String internalName, String displayName, List<String> description, String icon, int slot, boolean enabled, String permission) {
            this.internalName = internalName;
            this.displayName = displayName;
            this.description = description;
            this.icon = icon;
            this.slot = slot;
            this.enabled = enabled;
            this.permission = permission;
        }

        public String getInternalName() {
            return this.internalName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public List<String> getDescription() {
            return this.description;
        }

        public String getIcon() {
            return this.icon;
        }

        public int getSlot() {
            return this.slot;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getPermission() {
            return this.permission;
        }
    }
}

